/*
 * writeIndexedTable.hpp
 *
 *  Created on: Sep 28, 2013
 *      Author: heber
 */

#ifndef WRITEINDEXEDTABLE_HPP_
#define WRITEINDEXEDTABLE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/mpl/for_each.hpp>

#include <string>
#include <sstream>
#include <vector>

#include "Fragmentation/Summation/HeaderPrinter.hpp"
#include "Fragmentation/Summation/ValuePrinter.hpp"

/** Templated functor to write from a given vector of results the
 * table per keyset with decent header line.
 *
 * @param results vector of results of MapType
 * @param MaxLevel print values up till this level
 * @return string of the resulting table
 */
template <typename MapType, typename VectorType, int numprecision=10>
struct writeIndexedTable{
  std::string operator()(
      const std::map<IndexSet::ptr, std::pair<MapType,MapType> > &results,
      const size_t MaxLevel,
      const size_t StartLevel=1)
  {
    typedef std::map<IndexSet::ptr, std::pair<MapType,MapType> > maptype_t;
    std::stringstream resultstream;

    /// create header line for energy
    resultstream << "index\tlevel\tkeyset";
    {
      HeaderPrinter header("_value");
      boost::mpl::for_each<VectorType>(boost::ref(header));
      resultstream << header.get();
    }
    {
      HeaderPrinter header("_contribution");
      boost::mpl::for_each<VectorType>(boost::ref(header));
      resultstream << header.get();
    }
    resultstream << std::endl;

    /// print values per line
    if (MaxLevel >= StartLevel) {
      ASSERT( results.size() >= (MaxLevel-StartLevel),
          "writeIndexedTable<M,V>() - results has insufficient size.");
      size_t index = 0;
      for (typename maptype_t::const_iterator resultiter = results.begin();
          resultiter != results.end(); ++resultiter, ++index) {
        resultstream << index << "\t" << resultiter->first->size() << "\t" << "{";
        for (IndexSet::const_iterator keyiter = resultiter->first->begin();
            keyiter != resultiter->first->end(); ++keyiter)
          resultstream << ( keyiter != resultiter->first->begin() ? "," : "") << *keyiter;
        resultstream << "}";
        {
          ValuePrinter<MapType, numprecision> values(resultiter->second.first);
          boost::mpl::for_each<VectorType>(boost::ref(values));
          resultstream << values.get();
        }
        {
          ValuePrinter<MapType, numprecision> values(resultiter->second.second);
          boost::mpl::for_each<VectorType>(boost::ref(values));
          resultstream << values.get();
        }
        resultstream << std::endl;
      }
    } else {
      ELOG(2, "writeIndexedTable does not output as MaxLevel(" << MaxLevel
          << ") < StartLevel(" << StartLevel << ".");
    }
    return resultstream.str();
  }
};


#endif /* WRITEINDEXEDTABLE_HPP_ */
