/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ClearFragmentationResultsAction.cpp
 *
 *  Created on: Sep 28, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "Fragmentation/Summation/Containers/FragmentationResultContainer.hpp"

#include <boost/filesystem.hpp>
#include <string>

#include "Actions/FragmentationAction/ClearFragmentationResultsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ClearFragmentationResultsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr FragmentationClearFragmentationResultsAction::performCall() {

  FragmentationResultContainer::getInstance().clear();

  if (FragmentationResultContainer::getInstance().getShortRangeResults().empty()) {
    LOG(1, "STATUS: Fragmentation results cleared.");
    return Action::success;
  } else
    return Action::failure;
}

ActionState::ptr FragmentationClearFragmentationResultsAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr FragmentationClearFragmentationResultsAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool FragmentationClearFragmentationResultsAction::canUndo() {
  return true;
}

bool FragmentationClearFragmentationResultsAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
