/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * PdbAtomInfoContainer.cpp
 *
 *  Created on: Dec 4, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

//#include "Helpers/Assert.hpp"
//#include "Helpers/Log.hpp"
#include "Helpers/toString.hpp"
//#include "Helpers/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "PdbAtomInfoContainer.hpp"


PdbAtomInfoContainer::PdbAtomInfoContainer() :
  token("ATOM"),
  serial(0),
  name("-"),
  altLoc('0'),
  resName("-"),
  chainID('0'),
  resSeq(0),
  iCode(' '),
  occupancy(0.),
  tempFactor(0.),
  element(""),
  charge(0)
{}

PdbAtomInfoContainer::~PdbAtomInfoContainer()
{}

void PdbAtomInfoContainer::set(const PdbKey::PdbDataKey key, std::string value)
{
  switch (key) {
    case PdbKey::token :
      ScanKey(token, value);
      break;
    case PdbKey::serial :
      ScanKey(serial, value);
      break;
    case PdbKey::name :
      ScanKey(name, value);
      break;
    case PdbKey::altLoc :
      ScanKey(altLoc, value);
      break;
    case PdbKey::resName :
      ScanKey(resName, value);
      break;
    case PdbKey::chainID :
      ScanKey(chainID, value);
      break;
    case PdbKey::resSeq :
      ScanKey(resSeq, value);
      break;
    case PdbKey::iCode :
      ScanKey(iCode, value);
      break;
    case PdbKey::X :
      ScanKey(XYZ[0], value);
      break;
    case PdbKey::Y :
      ScanKey(XYZ[1], value);
      break;
    case PdbKey::Z :
      ScanKey(XYZ[2], value);
      break;
    case PdbKey::occupancy :
      ScanKey(occupancy, value);
      break;
    case PdbKey::tempFactor :
      ScanKey(tempFactor, value);
      break;
    case PdbKey::element :
      ScanKey(element, value);
      break;
    case PdbKey::charge :
      ScanKey(charge, value);
      break;
    default :
      std::cout << "Unknown key: " << key << ", value: " << value << std::endl;
      break;
  }
}

template <>
std::string PdbAtomInfoContainer::get<std::string>(const PdbKey::PdbDataKey key) const
{
  switch (key) {
    case PdbKey::token :
      return toString(token);
    case PdbKey::serial :
      return toString(serial);
    case PdbKey::name :
      return toString(name);
    case PdbKey::altLoc :
      return toString(altLoc);
    case PdbKey::resName :
      return toString(resName);
    case PdbKey::chainID :
      return toString(chainID);
    case PdbKey::resSeq :
      return toString(resSeq);
    case PdbKey::iCode :
      return toString(iCode);
    case PdbKey::X :
      return toString(XYZ[0]);
    case PdbKey::Y :
      return toString(XYZ[1]);
    case PdbKey::Z :
      return toString(XYZ[2]);
    case PdbKey::occupancy :
      return toString(occupancy);
    case PdbKey::tempFactor :
      return toString(tempFactor);
    case PdbKey::element :
      return toString(element);
    case PdbKey::charge :
      return toString(charge);
    default :
      std::cout << "Unknown key: " << key << std::endl;
      return "";
  }
}

template <>
int PdbAtomInfoContainer::get<int>(const PdbKey::PdbDataKey key) const
{
  switch (key) {
    case PdbKey::serial :
      return serial;
    case PdbKey::resSeq :
      return resSeq;
    case PdbKey::charge :
      return charge;
    default :
      std::cout << "Unknown key or not presentable as int: " << key << std::endl;
      return 0;
  }
}

template <>
double PdbAtomInfoContainer::get<double>(const PdbKey::PdbDataKey key) const
{
  switch (key) {
    case PdbKey::X :
      return XYZ[0];
    case PdbKey::Y :
      return XYZ[1];
    case PdbKey::Z :
      return XYZ[2];
    case PdbKey::occupancy :
      return occupancy;
    case PdbKey::tempFactor :
      return tempFactor;
    default :
      std::cout << "Unknown key or not presentable as double: " << key << std::endl;
      return 0.;
  }
}
