/*
 * Plane.hpp
 *
 *  Created on: Apr 7, 2010
 *      Author: crueger
 */

#ifndef PLANE_HPP_
#define PLANE_HPP_

#include <memory>
#include <vector>
#include "Space.hpp"
#include "Exceptions/LinearDependenceException.hpp"
#include "Exceptions/ZeroVectorException.hpp"

class Vector;

class Plane : public Space
{
  typedef std::auto_ptr<Vector> vec_ptr;
public:
  Plane(const Vector &y1, const Vector &y2, const Vector &y3) throw(LinearDependenceException);
  Plane(const Vector &y1, const Vector &y2, double _offset) throw(LinearDependenceException);
  Plane(const Vector &_normalVector, double _offset=0)  throw(ZeroVectorException);
  Plane(const Vector &_normalVector, const Vector &_offsetVector) throw(ZeroVectorException);
  virtual ~Plane();

  // Accessor Functions
  /**
   * returns normal Vector for a plane
   */
  Vector getNormal();
  /**
   * returns the distance of the plane from the origin
   */
  double getOffset();
  /**
   * returns a vector that points on the plane.
   * Same as getOffset()*getNormal();
   */
  Vector getOffsetVector();

  /**
   * returns three seperate points on this plane
   */
  std::vector<Vector> getPointsOnPlane();

  // some calculations
  Vector GetIntersection(const Vector &Origin, const Vector &LineVector);

  /****** Methods inherited from Space ***********/

  virtual double distance(const Vector &point) const;
  virtual Vector getClosestPoint(const Vector &point) const;

private:
  vec_ptr normalVector;
  double offset;
};

#endif /* PLANE_HPP_ */
