/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::UnsignedIntCommandLineQuery::UnsignedIntCommandLineQuery(Parameter<unsigned int> &_param, std::string title, std::string _description) :
    Dialog::TQuery<unsigned int>(_param, title, _description)
{}

CommandLineDialog::UnsignedIntCommandLineQuery::~UnsignedIntCommandLineQuery() {}

bool CommandLineDialog::UnsignedIntCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as<unsigned int>();
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing integer for " << getTitle() << ".");
    return false;
  }
}

