/*
 * ResultContainer_impl.hpp
 *
 *  Created on: Apr 22, 2014
 *      Author: heber
 */

#ifndef RESULTCONTAINER_IMPL_HPP_
#define RESULTCONTAINER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/Automation/ResultContainer.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/toString.hpp"

template <typename T>
void ResultContainer<T>::ConvertFragmentResultTo(
    const std::vector<FragmentResult::ptr> &results,
    std::vector<T> &fragmentData) const
{
  // extract results
  fragmentData.clear();
  fragmentData.reserve(results.size());

  LOG(2, "DEBUG: Parsing now through " << results.size() << " results.");
  for (std::vector<FragmentResult::ptr>::const_iterator iter = results.begin();
      iter != results.end(); ++iter) {
    //LOG(1, "RESULT: job #"+toString((*iter)->getId())+": "+toString((*iter)->result));
    T extractedData;
    std::stringstream inputstream((*iter)->result);
    LOG(2, "DEBUG: First 50 characters FragmentResult's string: "+(*iter)->result.substr(0, 50));
    boost::archive::text_iarchive ia(inputstream);
    ia >> extractedData;
    LOG(1, "INFO: extracted data of #" << (*iter)->getId() << " is " << extractedData << ".");
    fragmentData.push_back(extractedData);
  }

  ASSERT( results.size() == fragmentData.size(),
      "ResultContainer::ConvertFragmentResultTo() - the number of extracted data differs from the number of results.");
}

template <typename T>
void ResultContainer<T>::insertResults(
    const std::vector<FragmentResult::ptr> &fragmentresults,
    std::vector<T> &fragmentData)
{
  std::vector<FragmentResult::ptr>::const_iterator resultiter = fragmentresults.begin();
  typename std::vector<T>::const_iterator dataiter = fragmentData.begin();
  for(;resultiter != fragmentresults.end(); ++resultiter, ++dataiter) {
    const JobId_t _id = (*resultiter)->getId();
    if ((*resultiter)->exitflag == 0) {
#ifndef NDEBUG
      std::pair<typename std::map<JobId_t, T>::iterator, bool> inserter =
#endif
      IdData.insert( std::make_pair( _id, *dataiter) );
      ASSERT( inserter.second,
          "ResultContainer::insertResults() - result id "
          +toString(inserter.first->first)+" already present.");
    }
  }
  ASSERT( dataiter == fragmentData.end(),
      "ResultContainer::insertResults() - fragmentresults and fragmentdata differ in size.");
}


#endif /* RESULTCONTAINER_IMPL_HPP_ */
