/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MakroAction.cpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <string>

#include "Actions/MakroAction.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionExceptions.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionSequence.hpp"
#include "CodePatterns/Assert.hpp"
#include "UIElements/Dialog.hpp"
#include "UIElements/UIFactory.hpp"

using namespace MoleCuilder;

class MakroActionState : public ActionState{
public:
  MakroActionState(ActionSequence::stateSet _states) :
    states(_states)
  {}
  virtual ~MakroActionState(){
    // All contained states are destroyed by the shared ptrs
  }

  ActionSequence::stateSet states;
};

MakroAction::MakroAction(const ActionTrait &_trait,ActionSequence& _actions, ActionRegistry * const _AR) :
Action(_trait,_AR),
actions(_actions)
{
}

MakroAction::~MakroAction()
{
  // emptying the sequence is someone else responsibility
//  Action* action;
//  while((action=actions.removeLastAction())){
//    delete action;
//  }
}

void MakroAction::prepare(ActionRegistry &AR)
{}

void MakroAction::unprepare(ActionRegistry &AR)
{}

void MakroAction::setLoop(unsigned int _loop)
{
  actions.setLoop(_loop);
}

Dialog* MakroAction::fillDialog(Dialog *dialog) {
  return actions.fillAllDialogs(dialog);
}

Action::state_ptr MakroAction::performCall(){
  {
    // create and run our dialog and also of all members of the sequence
    Dialog* dialog = actions.fillAllDialogs(createDialog());
    if (dialog->hasQueries()) {
      if (!dialog->display())
        // dialog error or aborted -> throw exception
        throw ActionFailureException() << ActionNameString(getName());
    }
    delete(dialog);
  }
  ActionSequence::stateSet states = actions.callAll(true);
  return Action::state_ptr(new MakroActionState(states));
}

Action::state_ptr MakroAction::performUndo(Action::state_ptr _state) {
  MakroActionState *state = dynamic_cast<MakroActionState*>(_state.get());
  ASSERT(state,"Type mismatch for the state of the MakroAction");
  ActionSequence::stateSet states = actions.undoAll(state->states);
  return Action::state_ptr(new MakroActionState(states));
}

Action::state_ptr MakroAction::performRedo(Action::state_ptr _state){
  MakroActionState *state = dynamic_cast<MakroActionState*>(_state.get());
  ASSERT(state,"Type mismatch for the state of the MakroAction");
  ActionSequence::stateSet states = actions.redoAll(state->states);
  return Action::state_ptr(new MakroActionState(states));
}

bool MakroAction::canUndo() {
  return actions.canUndo();
}

bool MakroAction::shouldUndo() {
  return actions.shouldUndo();
}
