/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * EmptyCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::EmptyCommandLineQuery::EmptyCommandLineQuery(string title, string _description) :
    Dialog::EmptyQuery(title, _description)
{}

CommandLineDialog::EmptyCommandLineQuery::~EmptyCommandLineQuery() {}

bool CommandLineDialog::EmptyCommandLineQuery::handle() {
  cout << "Message of " << getTitle() << ":\n" << getDescription() << "\n";
  return true;
}

