/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAllAtomsAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomDescriptor.hpp"
#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <boost/foreach.hpp>
#include <iostream>
#include <string>

#include "NotAllAtomsAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAllAtomsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAllAtomsAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();
  LOG(1, "Unselecting all atoms.");
  World::getInstance().clearAtomSelection();
  LOG(0, World::getInstance().countSelectedAtoms() << " atoms remain selected.");
  return Action::state_ptr(new SelectionNotAllAtomsState(selectedAtoms, params));
}

Action::state_ptr SelectionNotAllAtomsAction::performUndo(Action::state_ptr _state) {
  SelectionNotAllAtomsState *state = assert_cast<SelectionNotAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();
  BOOST_FOREACH(atom *_atom, state->unselectedAtoms)
    World::getInstance().selectAtom(_atom);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAllAtomsAction::performRedo(Action::state_ptr _state){
  //SelectionNotAllAtomsState *state = assert_cast<SelectionNotAllAtomsState*>(_state.get());

  World::getInstance().clearAtomSelection();

  return Action::state_ptr(_state);
}

bool SelectionNotAllAtomsAction::canUndo() {
  return true;
}

bool SelectionNotAllAtomsAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
