/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Atom/atom.hpp"
#include "CodePatterns/Log.hpp"
#include "Fragmentation/Fragmentation.hpp"
#include "Fragmentation/HydrogenSaturation_enum.hpp"
#include "Graph/DepthFirstSearchAnalysis.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/FragmentationAction/FragmentationAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "FragmentationAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr FragmentationFragmentationAction::performCall() {
  clock_t start,end;
  molecule *mol = NULL;
  int ExitFlag = 0;

  // obtain information
  getParametersfromValueStorage();

  LOG(0, "STATUS: Fragmenting molecular system with current connection matrix maximum bond distance "
      << params.distance << " up to "
      << params.order << " order. Fragment files begin with "
      << params.prefix << " and are stored as: "
      << params.types << "." << std::endl);

  DepthFirstSearchAnalysis DFS;
  for (World::MoleculeSelectionConstIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    ASSERT(mol != NULL, "No molecule has been picked for fragmentation.");
    LOG(2, "INFO: Fragmenting molecule with bond distance " << params.distance << " angstroem, order of " << params.order << ".");
    start = clock();
    if (mol->hasBondStructure()) {
      Fragmentation Fragmenter(mol, params.DoSaturation ? DoSaturate : DontSaturate);
      Fragmenter.setOutputTypes(params.types);
      ExitFlag = Fragmenter.FragmentMolecule(params.order, params.prefix, DFS);
    }
    World::getInstance().setExitFlag(ExitFlag);
    end = clock();
    LOG(0, "STATUS: Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s.");
  }
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationFragmentationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationFragmentationAction::canUndo() {
  return true;
}

bool FragmentationFragmentationAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
