/*
 * logger.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#include <fstream>
#include "logger.hpp"
#include "verbose.hpp"

ofstream nullStream("/dev/null");

logger* logger::instance = NULL;
int logger::verbosity = 0;
ostream* logger::nix = &nullStream;

/**
 * Constructor. Do not use this function. Use getInstance() instead.
 *
 * \return logger instance
 */
logger::logger()
{
  instance = NULL;
  verbosity = 0;
};

/**
 * Destructor. Better use purgeInstance().
 */
logger::~logger() {
  verbosity = 0;
}

/**
 * Returns the singleton logger instance.
 *
 * \return logger instance
 */
logger* logger::getInstance() {
  if (instance == NULL) {
    instance = new logger();
  }

  return instance;
}


/**
 * Purges the current logger instance.
 */
void logger::purgeInstance() {
  if (instance != NULL) {
    delete instance;
  }

  instance = NULL;
}

/**
 * Sets the verbosity.
 *
 * \param verbosityLevel verbosity
 */
void logger::setVerbosity(int verbosityLevel) {
  verbosity = verbosityLevel;
}

/**
 * Operator for the Binary(arg) call.
 * Constructs temporary a Verbose class object, wherein the Binary is stored.
 * Then << is called, which calls Binary's print which adds the tabs and logs
 * the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Binary object
 * \return &ost
 */
ostream& operator<<(class logger& l, const Verbose& v)
{
  int verbosityLevel = l.verbosity;
  l.nix->clear();
  if (v.DoOutput(verbosityLevel))
    return cout;
  else
    return *l.nix;
};
ostream& operator<<(class logger* l, const Verbose& v)
{
  int verbosityLevel = l->verbosity;
  l->nix->clear();
  if (v.DoOutput(verbosityLevel))
    return cout;
  else
    return *l->nix;
};

